CREATE OR REPLACE FUNCTION scheduling.ksvba__resource__transport_defaults(ks_abt__from varchar, ks_abt__to varchar) 
  RETURNS int 
  AS $$
  DECLARE
      _r record;
-- TODO ZUSAMMENFASSEN MIT UNTEN  
      -- 15 min / 4h inter ksv tranport time
      _transport_time_inter_ksv CONSTANT int := 60 * 15; -- 14400

      -- 4 hours / 8h from ksv to ksv internally
      _transport_time_internal_ksv CONSTANT int := 60 * 60 * 4; -- 28800

      -- 48h 2 day from internal ksv to external ksv
      -- should be tuncated to single days
      _transport_time_internal_ksv_to_external CONSTANT int := 60 * 60 * 24 * 2;

      -- 24h 1 days from external ksv to internal ksv
      -- should be tuncated to single days
      _transport_time_external_ksv_to_internal CONSTANT int := 60 * 60 * 24;

      -- 72h 3 day from external ksv to external ksv
      -- should be tuncated to single days
      _transport_time_external_ksv_to_external CONSTANT int := 60 * 60 * 24 * 3;  
  BEGIN
      SELECT ksv_f.ks_abt AS ks_abt__from, ksv_f.ks_ausw AS ks_ausw__from, 
             ksv_t.ks_abt AS ks_abt__to,   ksv_t.ks_ausw AS ks_ausw__to
        INTO _r
        FROM ksv ksv_f, 
             ksv ksv_t
       WHERE ksv_f.ks_abt = ks_abt__from
         AND ksv_t.ks_abt = ks_abt__to;

      IF _r.ks_abt__from = _r.ks_abt__to THEN
        RETURN _transport_time_inter_ksv;
      END IF;

      IF _r.ks_ausw__from  IS false AND _r.ks_ausw__to IS true THEN
        RETURN _transport_time_internal_ksv_to_external;
      END IF;

      IF _r.ks_ausw__from  IS true AND _r.ks_ausw__to IS false THEN
        RETURN _transport_time_external_ksv_to_internal;
      END IF;

      IF _r.ks_ausw__from  IS true AND _r.ks_ausw__to IS true THEN
        RETURN _transport_time_external_ksv_to_external;
      END IF;

      RETURN _transport_time_internal_ksv;

  END $$ LANGUAGE plpgsql STABLE PARALLEL SAFE;



SELECT tsystem.function__drop_by_regex( 'ksvba__resource__transport_update', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ksvba__resource__transport_update(
      _new_state ksvba,
      _old_state ksvba
  ) RETURNS void AS $$
  DECLARE

      _is_extern    bool   := ks_ausw IS true FROM ksv WHERE _new_state.ksb_ks_id = ksv.ks_id;

      _resource_id  int    := id FROM scheduling.resource WHERE context = 'ksvba' AND context_id = _new_state.ksb_id;
      _ksv_record   record;

      _value_to_check int;

      _required_work   int := 0;
      _required_buffer int := 0;

-- TODO ZUSAMMENFASSEN MIT OBEN      
      -- 15 min / 4h inter ksv tranport time
      _transport_time_inter_ksv CONSTANT int := 60 * 15; -- 14400

      -- 4 hours / 8h from ksv to ksv internally
      _transport_time_internal_ksv CONSTANT int := 60 * 60 * 4; -- 28800

      -- 48h 2 day from internal ksv to external ksv
      -- should be tuncated to single days
      _transport_time_internal_ksv_to_external CONSTANT int := 60 * 60 * 24 * 2;

      -- 24h 1 days from external ksv to internal ksv
      -- should be tuncated to single days
      _transport_time_external_ksv_to_internal CONSTANT int := 60 * 60 * 24;

      -- 72h 3 day from external ksv to external ksv
      -- should be tuncated to single days
      _transport_time_external_ksv_to_external CONSTANT int := 60 * 60 * 24 * 3;


  BEGIN

    -- remove any default routes for updating
    DELETE FROM scheduling.resource_transport
    WHERE
          scheduling.resource_transport.default_rule IS TRUE
      AND (
               scheduling.resource_transport.resource_id_from = _resource_id
            OR scheduling.resource_transport.resource_id_to   = _resource_id
          )
    ;


    FOR _ksv_record IN
        -- alle anderen Resourcen/Kostenstellen!
        SELECT scheduling.resource.id, ks_ausw, ks_abt
          FROM scheduling.resource
          JOIN ksvba ON scheduling.resource.context = 'ksvba' AND scheduling.resource.context_id = ksvba.ksb_id
          JOIN ksv   ON ksvba.ksb_ks_id = ksv.ks_id
         WHERE
               scheduling.resource.id <> _resource_id
    LOOP

        _required_work   := 0;
        _required_buffer := 0;

        IF (
                _is_extern IS true
            AND _ksv_record.ks_ausw IS true
        ) THEN

            _required_buffer := _transport_time_external_ksv_to_external;
        END IF;

        IF (
                _is_extern IS false
            AND _ksv_record.ks_ausw IS true
        ) THEN

            _required_buffer := _transport_time_internal_ksv_to_external;
        END IF;

        IF (
                _is_extern IS true
            AND _ksv_record.ks_ausw IS false
        ) THEN

            _required_buffer := _transport_time_external_ksv_to_internal;
        END IF;

        IF (
                _is_extern IS false
            AND _ksv_record.ks_ausw IS false
        ) THEN

            IF (
                  _ksv_record.ks_abt
                = (
                    SELECT ksb_ks_abt
                    FROM scheduling.resource
                    JOIN ksvba ON ksb_id = context_id
                    WHERE
                          scheduling.resource.context = 'ksvba'
                      AND scheduling.resource.id = _resource_id
                  )
            ) THEN

                -- transport for same ksv
                _required_buffer := _transport_time_inter_ksv;
            ELSE

                -- transport for distinct ksvs
                _required_buffer := _transport_time_internal_ksv;
            END IF;
        END IF;


        -- only insert transportime if no custom transporttime is already defined
        IF (
            NOT EXISTS(
                SELECT true
                  FROM scheduling.resource_transport
                 WHERE
                       resource_id_from = _resource_id
                   AND resource_id_to   = _ksv_record.id
            )
        ) THEN

            INSERT INTO scheduling.resource_transport ( resource_id_from , resource_id_to, work_required, buffer_time, buffer_time_default ) VALUES (
                _resource_id,
                _ksv_record.id,
                _required_work,
                _required_buffer,
                _required_buffer
            );

        END IF;

        -- since all except internal to external times are the symmetrical,
        -- we just flip them around in that special case
        -- otherwise they will be inserted both ways
        IF ( _required_buffer = _transport_time_internal_ksv_to_external ) THEN

            _required_buffer = _transport_time_external_ksv_to_internal;

        ELSEIF ( _required_buffer = _transport_time_external_ksv_to_internal ) THEN

            _required_buffer = _transport_time_internal_ksv_to_external;

        END IF;

        -- only insert transportime if no custom transporttime is already defined
        IF (
            NOT EXISTS(
                SELECT true
                  FROM scheduling.resource_transport
                 WHERE
                       resource_id_from = _ksv_record.id
                   AND resource_id_to   = _resource_id
            )
        ) THEN
            INSERT INTO scheduling.resource_transport ( resource_id_from , resource_id_to, work_required, buffer_time, buffer_time_default ) VALUES (
                _ksv_record.id,
                _resource_id,
                _required_work,
                _required_buffer,
                _required_buffer
            );
        END IF;

    END LOOP;

  END $$ LANGUAGE plpgsql;
